//------------------------------------------------------------------
#property copyright "mladen"
#property link      "www.forex-station.cm"
//------------------------------------------------------------------
#property indicator_separate_window
#property indicator_buffers 8
#property indicator_minimum 0
#property indicator_maximum 5
#property strict

//
//
//
//
//

enum enTimeFrames
{
   tf_cu  = PERIOD_CURRENT, // Current time frame
   tf_m1  = PERIOD_M1,      // 1 minute
   tf_m5  = PERIOD_M5,      // 5 minutes
   tf_m15 = PERIOD_M15,     // 15 minutes
   tf_m30 = PERIOD_M30,     // 30 minutes
   tf_h1  = PERIOD_H1,      // 1 hour
   tf_h4  = PERIOD_H4,      // 4 hours
   tf_d1  = PERIOD_D1,      // Daily
   tf_w1  = PERIOD_W1,      // Weekly
   tf_mn1 = PERIOD_MN1,     // Monthly
   tf_n1  = -1,             // First higher time frame
   tf_n2  = -2,             // Second higher time frame
   tf_n3  = -3              // Third higher time frame
};

extern enTimeFrames TimeFrame1            = tf_cu;                       // First time frame
extern enTimeFrames TimeFrame2            = tf_n1;                       // Second time frame
extern enTimeFrames TimeFrame3            = tf_n2;                       // Third time frame
extern enTimeFrames TimeFrame4            = tf_n3;                       // Fourth time frame
extern int          MaPeriod              = 21;
enum  enMaTypes
      {
         ma_sma,                                                         // Simple moving average
         ma_ema,                                                         // Exponential moving average
         ma_smma,                                                        // Smoothed MA
         ma_lwma,                                                        // Linear weighted MA
         ma_slwma,                                                       // Smoothed LWMA
         ma_dsema,                                                       // Double Smoothed Exponential average
         ma_tema,                                                        // Triple exponential moving average - TEMA
         ma_lsma                                                         // Linear regression value (lsma)
};
extern enMaTypes    MaMethod              = ma_lwma;                     // Moving average method 
enum  enPrices
      {
         pr_close,                                                       // Close
         pr_open,                                                        // Open
         pr_high,                                                        // High
         pr_low,                                                         // Low
         pr_median,                                                      // Median
         pr_typical,                                                     // Typical
         pr_weighted,                                                    // Weighted
         pr_average,                                                     // Average (high+low+open+close)/4
         pr_medianb,                                                     // Average median body (open+close)/2
         pr_tbiased,                                                     // Trend biased price
         pr_tbiased2,                                                    // Trend biased (extreme) price
         pr_haclose,                                                     // Heiken ashi close
         pr_haopen,                                                      // Heiken ashi open
         pr_hahigh,                                                      // Heiken ashi high
         pr_halow,                                                       // Heiken ashi low
         pr_hamedian,                                                    // Heiken ashi median
         pr_hatypical,                                                   // Heiken ashi typical
         pr_haweighted,                                                  // Heiken ashi weighted
         pr_haaverage,                                                   // Heiken ashi average
         pr_hamedianb,                                                   // Heiken ashi median body
         pr_hatbiased,                                                   // Heiken ashi trend biased price
         pr_hatbiased2,                                                  // Heiken ashi trend biased (extreme) price
         pr_habclose,                                                    // Heiken ashi (better formula) close
         pr_habopen,                                                     // Heiken ashi (better formula) open
         pr_habhigh,                                                     // Heiken ashi (better formula) high
         pr_hablow,                                                      // Heiken ashi (better formula) low
         pr_habmedian,                                                   // Heiken ashi (better formula) median
         pr_habtypical,                                                  // Heiken ashi (better formula) typical
         pr_habweighted,                                                 // Heiken ashi (better formula) weighted
         pr_habaverage,                                                  // Heiken ashi (better formula) average
         pr_habmedianb,                                                  // Heiken ashi (better formula) median body
         pr_habtbiased,                                                  // Heiken ashi (better formula) trend biased price
         pr_habtbiased2                                                  // Heiken ashi (better formula) trend biased (extreme) price
      };
input enPrices      MaPrice               = pr_medianb;                  // Price to use
extern string       UniqueID              = "4 Timeframe price cross ma";// Unique ID
extern bool         alertsOn              = false;                       // Alerts?
extern int          alertsLevel           = 3;                           // Alerts number of timeframes lined up
extern bool         alertsMessage         = true;                        // Alerts message?
extern bool         alertsSound           = false;                       // Alerts sound?
extern bool         alertsEmail           = false;                       // Alerts email?
extern bool         alertsNotify          = false;                       // Alerts notification
extern int          LinesWidth            = 0;                           // Lines width
input bool          ShowLabels            = false;                       // Show labels
extern color        LabelsColor           = clrDarkGray;                 // Lines color
extern int          LabelsHorizontalShift = 5;                           // Labels horizontal shift
extern double       LabelsVerticalShift   = 1.10;                        // Labels vertical shift
extern color        ColorUp               = clrDodgerBlue;               // Color for up
extern color        ColorDown             = clrSandyBrown;               // Color for down

double ma1u[],ma1d[],ma2u[],ma2d[],ma3u[],ma3d[],ma4u[],ma4d[],count[];

int    timeFrames[4];
bool   returnBars;
bool   calculateValue;
string indicatorFileName;

//------------------------------------------------------------------
//
//------------------------------------------------------------------

int OnInit()
{
   SetIndexBuffer(0,ma1u);
   SetIndexBuffer(1,ma1d);
   SetIndexBuffer(2,ma2u);
   SetIndexBuffer(3,ma2d);
   SetIndexBuffer(4,ma3u);
   SetIndexBuffer(5,ma3d);
   SetIndexBuffer(6,ma4u);
   SetIndexBuffer(7,ma4d);
   
   indicatorFileName = WindowExpertName();
   returnBars        = (TimeFrame1==-99); if (returnBars)     return(0);
   calculateValue    = (TimeFrame1==-98); if (calculateValue) return(0);
      
   //
   //
   //
      
   for (int i=0; i<8; i++)  {  SetIndexStyle(i,DRAW_ARROW,EMPTY,LinesWidth,i%2==0?ColorUp:ColorDown); SetIndexArrow(i,110); }
   timeFrames[0] = timeFrameValue(TimeFrame1);
   timeFrames[1] = timeFrameValue(TimeFrame2);
   timeFrames[2] = timeFrameValue(TimeFrame3);
   timeFrames[3] = timeFrameValue(TimeFrame4);
      
   alertsLevel = fmin(fmax(alertsLevel,3),4);
      
   IndicatorSetString(INDICATOR_SHORTNAME,UniqueID);
return(INIT_SUCCEEDED);
}
void OnDeinit(const int reason){ ObjectsDeleteAll(0,UniqueID); return; }

//------------------------------------------------------------------
//
//------------------------------------------------------------------
//
//
//
//
//

double trend[][2];
#define _up 0
#define _dn 1
int start()
{
   int i,r,counted_bars=IndicatorCounted();
      if(counted_bars < 0) return(-1);
      if(counted_bars>0) counted_bars--;
         int limit = MathMin(Bars-counted_bars,Bars-1);
         if (returnBars) { ma1u[0] = limit+1; return(0); }
         if (calculateValue) { calculateByPrcCross(limit); return(0); }

         if (timeFrames[0] != _Period) limit = (int)fmax(limit,fmin(Bars-1,iCustom(NULL,timeFrames[0],indicatorFileName,-99,0,0)*timeFrames[0]/_Period));
         if (timeFrames[1] != _Period) limit = (int)fmax(limit,fmin(Bars-1,iCustom(NULL,timeFrames[1],indicatorFileName,-99,0,0)*timeFrames[1]/_Period));
         if (timeFrames[2] != _Period) limit = (int)fmax(limit,fmin(Bars-1,iCustom(NULL,timeFrames[2],indicatorFileName,-99,0,0)*timeFrames[2]/_Period));
         if (timeFrames[3] != _Period) limit = (int)fmax(limit,fmin(Bars-1,iCustom(NULL,timeFrames[3],indicatorFileName,-99,0,0)*timeFrames[3]/_Period));
         if (ArrayRange(trend,0)!=Bars) ArrayResize(trend,Bars);


         //
         //
         //
         //
         //
         
         if (ShowLabels)
         {
            bool initialized = false;
            if (!initialized)
            {
               initialized = true;
               int window = WindowFind(UniqueID);
               for (int t=0; t<4; t++)
               {
                  string label = timeFrameToString(timeFrames[t]);
                  ObjectCreate(UniqueID+(string)t,OBJ_TEXT,window,0,0);
                     ObjectSet(UniqueID+(string)t,OBJPROP_COLOR,LabelsColor);
                     ObjectSet(UniqueID+(string)t,OBJPROP_PRICE1,t+LabelsVerticalShift);
                     ObjectSetText(UniqueID+(string)t,label,8,"Arial");
               }               
            }
            for (int t=0; t<4; t++) ObjectSet(UniqueID+(string)t,OBJPROP_TIME1,Time[0]+Period()*LabelsHorizontalShift*60);
         }

   //
   //
   //
   //
   //
   
   for(i = limit, r=Bars-i-1; i >= 0; i--,r++)
   {
      trend[r][_up] = 0;
      trend[r][_dn] = 0;
      for (int k=0; k<4; k++)
      {
         int y = iBarShift(NULL,timeFrames[k],Time[i]);
            double ma  = iCustom(NULL,timeFrames[k],indicatorFileName,-98,0,0,0,MaPeriod,MaMethod,MaPrice,7,y);
            bool   isUp = (ma>0);
          
            switch (k)
            {
               case 0 : if (isUp) { ma1u[i] = k+1; ma1d[i] = EMPTY_VALUE;}  else { ma1d[i] = k+1; ma1u[i] = EMPTY_VALUE; } break;
               case 1 : if (isUp) { ma2u[i] = k+1; ma2d[i] = EMPTY_VALUE;}  else { ma2d[i] = k+1; ma2u[i] = EMPTY_VALUE; } break;
               case 2 : if (isUp) { ma3u[i] = k+1; ma3d[i] = EMPTY_VALUE;}  else { ma3d[i] = k+1; ma3u[i] = EMPTY_VALUE; } break;
               case 3 : if (isUp) { ma4u[i] = k+1; ma4d[i] = EMPTY_VALUE;}  else { ma4d[i] = k+1; ma4u[i] = EMPTY_VALUE; } break;
            }
            if (isUp)
                  trend[r][_up] += 1;
            else  trend[r][_dn] += 1;
      }
   }
   manageAlerts();
return(0);
}

//-------------------------------------------------------------------
//
//-------------------------------------------------------------------

void calculateByPrcCross(int limit)
{
   for (int i=limit; i>=0; i--) 
   {
      ma2u[i] = Close[i];  
      ma2d[i] = iCustomMa(MaMethod,iGetPrice(MaPrice,Open,High,Low,Close,i,Bars),MaPeriod,i,Bars); 
      ma4d[i] = (i<Bars-1) ? (ma2u[i]>ma2d[i]) ? 1 : (ma2u[i]<ma2d[i]) ? -1 : ma4d[i+1] : 0; 
      ma1u[i] = (ma4d[i] == 1) ? 1 : EMPTY_VALUE;
      ma1d[i] = (ma4d[i] ==-1) ? 1 : EMPTY_VALUE;          
   }
}

//-------------------------------------------------------------------
//
//-------------------------------------------------------------------

void manageAlerts()
{
   if (alertsOn)
   {
      int whichBar = Bars-1; 
      static datetime time1 = 0;
      static string   mess1 = "";
      if (trend[whichBar][_up]>=alertsLevel || trend[whichBar][_dn]>=alertsLevel)
      {
         if (trend[whichBar][_up] >= alertsLevel && trend[whichBar-1][_up]<alertsLevel) doAlert(time1,mess1,whichBar,"up",  (int)trend[whichBar][_up]);
         if (trend[whichBar][_dn] >= alertsLevel && trend[whichBar-1][_dn]<alertsLevel) doAlert(time1,mess1,whichBar,"down",(int)trend[whichBar][_dn]);
      }              
    }         
}

//
//
//

void doAlert(datetime& previousTime, string& previousAlert, int forBar, string doWhat, int howMany)
{
   string message;
   
   if (previousAlert != doWhat || previousTime != Time[forBar]) {
       previousAlert  = doWhat;
       previousTime   = Time[forBar];

       //
       //
       //
       //
       //

        message =  _Symbol+" at "+TimeToStr(TimeLocal(),TIME_SECONDS)+" "+(string)howMany+" time frames of price crossing ma are aligned "+doWhat;
          if (alertsMessage) Alert(message);
          if (alertsEmail)   SendMail(_Symbol+" 4 time frame price cross ma ",message);
          if (alertsNotify)  SendNotification(message);
          if (alertsSound)   PlaySound("alert2.wav");
   }
}

//-------------------------------------------------------------------
//
//-------------------------------------------------------------------

string sTfTable[] = {"M1","M5","M15","M30","H1","H4","D1","W1","MN"};
int    iTfTable[] = {1,5,15,30,60,240,1440,10080,43200};

//
//
//

int timeFrameValue(int _tf)
{
   int add  = (_tf>=0) ? 0 : fabs(_tf);
   if (add != 0) _tf = _Period;
   int size = ArraySize(iTfTable); 
      int i =0; for (;i<size; i++) if (iTfTable[i]==_tf) break;
                                   if (i==size) return(_Period);
                                                return(iTfTable[(int)MathMin(i+add,size-1)]);
}
string timeFrameToString(int tf)
{
   for (int i=ArraySize(iTfTable)-1; i>=0; i--) 
         if (tf==iTfTable[i]) return(sTfTable[i]);
                              return("");
}

//------------------------------------------------------------------
//                                                                  
//------------------------------------------------------------------

#define _maInstances 1
#define _maWorkBufferx1 1*_maInstances
#define _maWorkBufferx2 2*_maInstances
#define _maWorkBufferx3 3*_maInstances

double iCustomMa(int mode, double price, double length, int r, int bars, int instanceNo=0)
{
   r = bars-r-1;
   switch (mode)
   {
      case ma_sma   : return(iSma(price,(int)length,r,bars,instanceNo));
      case ma_ema   : return(iEma(price,length,r,bars,instanceNo));
      case ma_smma  : return(iSmma(price,(int)length,r,bars,instanceNo));
      case ma_lwma  : return(iLwma(price,(int)length,r,bars,instanceNo));
      case ma_slwma : return(iSlwma(price,(int)length,r,bars,instanceNo));
      case ma_dsema : return(iDsema(price,length,r,bars,instanceNo));
      case ma_tema  : return(iTema(price,(int)length,r,bars,instanceNo));
      case ma_lsma  : return(iLinr(price,(int)length,r,bars,instanceNo));
      default       : return(price);
   }
}

//
//
//
//
//

double workSma[][_maWorkBufferx1];
double iSma(double price, int period, int r, int _bars, int instanceNo=0)
{
   if (ArrayRange(workSma,0)!= _bars) ArrayResize(workSma,_bars);

   workSma[r][instanceNo+0] = price;
   double avg = price; int k=1;  for(; k<period && (r-k)>=0; k++) avg += workSma[r-k][instanceNo+0];  
   return(avg/(double)k);
}

//
//
//
//
//

double workEma[][_maWorkBufferx1];
double iEma(double price, double period, int r, int _bars, int instanceNo=0)
{
   if (ArrayRange(workEma,0)!= _bars) ArrayResize(workEma,_bars);

   workEma[r][instanceNo] = price;
   if (r>0 && period>1)
          workEma[r][instanceNo] = workEma[r-1][instanceNo]+(2.0/(1.0+period))*(price-workEma[r-1][instanceNo]);
   return(workEma[r][instanceNo]);
}

//
//
//
//
//

double workSmma[][_maWorkBufferx1];
double iSmma(double price, double period, int r, int _bars, int instanceNo=0)
{
   if (ArrayRange(workSmma,0)!= _bars) ArrayResize(workSmma,_bars);

   workSmma[r][instanceNo] = price;
   if (r>1 && period>1)
          workSmma[r][instanceNo] = workSmma[r-1][instanceNo]+(price-workSmma[r-1][instanceNo])/period;
   return(workSmma[r][instanceNo]);
}

//
//
//
//
//

double workLwma[][_maWorkBufferx1];
double iLwma(double price, double period, int r, int _bars, int instanceNo=0)
{
   if (ArrayRange(workLwma,0)!= _bars) ArrayResize(workLwma,_bars);
   
   workLwma[r][instanceNo] = price; if (period<=1) return(price);
      double sumw = period;
      double sum  = period*price;

      for(int k=1; k<period && (r-k)>=0; k++)
      {
         double weight = period-k;
                sumw  += weight;
                sum   += weight*workLwma[r-k][instanceNo];  
      }             
      return(sum/sumw);
}

//
//
//
//
//


double workSlwma[][_maWorkBufferx2];
double iSlwma(double price, double period, int r, int _bars, int instanceNo=0)
{
   if (ArrayRange(workSlwma,0)!= _bars) ArrayResize(workSlwma,_bars); 

   //
   //
   //
   //
   //

      int SqrtPeriod = (int)MathFloor(MathSqrt(period)); instanceNo *= 2;
         workSlwma[r][instanceNo] = price;

         //
         //
         //
         //
         //
               
         double sumw = period;
         double sum  = period*price;
   
         for(int k=1; k<period && (r-k)>=0; k++)
         {
            double weight = period-k;
                   sumw  += weight;
                   sum   += weight*workSlwma[r-k][instanceNo];  
         }             
         workSlwma[r][instanceNo+1] = (sum/sumw);

         //
         //
         //
         //
         //
         
         sumw = SqrtPeriod;
         sum  = SqrtPeriod*workSlwma[r][instanceNo+1];
            for(int k=1; k<SqrtPeriod && (r-k)>=0; k++)
            {
                double weight = SqrtPeriod-k;
                   sumw      += weight;
                   sum       += weight*workSlwma[r-k][instanceNo+1];  
            }
   return(sum/sumw);
}

//
//
//
//
//

double workDsema[][_maWorkBufferx2];
#define _ema1 0
#define _ema2 1

double iDsema(double price, double period, int r, int _bars, int instanceNo=0)
{
   if (ArrayRange(workDsema,0)!= _bars) ArrayResize(workDsema,_bars); instanceNo*=2;

   //
   //
   //
   //
   //
   
   workDsema[r][_ema1+instanceNo] = price;
   workDsema[r][_ema2+instanceNo] = price;
   if (r>0 && period>1)
   {
      double alpha = 2.0 /(1.0+MathSqrt(period));
          workDsema[r][_ema1+instanceNo] = workDsema[r-1][_ema1+instanceNo]+alpha*(price                         -workDsema[r-1][_ema1+instanceNo]);
          workDsema[r][_ema2+instanceNo] = workDsema[r-1][_ema2+instanceNo]+alpha*(workDsema[r][_ema1+instanceNo]-workDsema[r-1][_ema2+instanceNo]); }
   return(workDsema[r][_ema2+instanceNo]);
}

//
//
//
//
//

double workTema[][_maWorkBufferx3];
#define _tema1 0
#define _tema2 1
#define _tema3 2

double iTema(double price, double period, int r, int bars, int instanceNo=0)
{
   if (ArrayRange(workTema,0)!= bars) ArrayResize(workTema,bars); instanceNo*=3;

   //
   //
   //
   //
   //
      
   workTema[r][_tema1+instanceNo] = price;
   workTema[r][_tema2+instanceNo] = price;
   workTema[r][_tema3+instanceNo] = price;
   if (r>0 && period>1)
   {
      double alpha = 2.0 / (1.0+period);
          workTema[r][_tema1+instanceNo] = workTema[r-1][_tema1+instanceNo]+alpha*(price                         -workTema[r-1][_tema1+instanceNo]);
          workTema[r][_tema2+instanceNo] = workTema[r-1][_tema2+instanceNo]+alpha*(workTema[r][_tema1+instanceNo]-workTema[r-1][_tema2+instanceNo]);
          workTema[r][_tema3+instanceNo] = workTema[r-1][_tema3+instanceNo]+alpha*(workTema[r][_tema2+instanceNo]-workTema[r-1][_tema3+instanceNo]); }
   return(workTema[r][_tema3+instanceNo]+3.0*(workTema[r][_tema1+instanceNo]-workTema[r][_tema2+instanceNo]));
}

//
//
//
//
//

double workLinr[][_maWorkBufferx1];
double iLinr(double price, int period, int r, int bars, int instanceNo=0)
{
   if (ArrayRange(workLinr,0)!= bars) ArrayResize(workLinr,bars);

   //
   //
   //
   //
   //
   
      period = MathMax(period,1);
      workLinr[r][instanceNo] = price;
      if (r<period) return(price);
         double lwmw = period; double lwma = lwmw*price;
         double sma  = price;
         for(int k=1; k<period && (r-k)>=0; k++)
         {
            double weight = period-k;
                   lwmw  += weight;
                   lwma  += weight*workLinr[r-k][instanceNo];  
                   sma   +=        workLinr[r-k][instanceNo];
         }             
   
   return(3.0*lwma/lwmw-2.0*sma/period);
}

//--------------------------------------------------------------------------------------------------------------------------------------
//                                                                  
//--------------------------------------------------------------------------------------------------------------------------------------

template <typename T>
double iGetPrice(int tprice, T& open[], T& high[], T& low[], T& close[], int i, int bars)
{
   if (tprice>=pr_haclose)
   {
      struct sHaStruct
      {
         double open;
         double high;
         double low;
         double close;
      };
      static sHaStruct m_array[];
      static int       m_arraySize = -1;
                   if (m_arraySize<bars) m_arraySize = ArrayResize(m_array,bars+500);
                   
         //
         //
         //
                            
         #ifdef __MQL4__                  
            int r = bars-i-1;
         #else            
            int r = i;
         #endif            
         
         //
         //
         //
         
         double haOpen  = (r>0) ? (m_array[r-1].open + m_array[r-1].close)/2.0 : (open[i]+close[i])/2;;
         double haClose = (open[i]+high[i]+low[i]+close[i]) / 4.0;
         #define _prHABF(_prtype) (_prtype>=pr_habclose && _prtype<=pr_habtbiased2)
            if (_prHABF(tprice))
                  if (high[i]!=low[i])
                        haClose = (open[i]+close[i])/2.0+(((close[i]-open[i])/(high[i]-low[i]))*MathAbs((close[i]-open[i])/2.0));
                  else  haClose = (open[i]+close[i])/2.0; 
         #undef  _prHABF                  
         double haHigh  = fmax(high[i], fmax(haOpen,haClose));
         double haLow   = fmin(low[i] , fmin(haOpen,haClose));

         //
         //
         //
         
         if(haOpen<haClose) { m_array[r].high  = haLow;  m_array[r].low = haHigh; } 
         else               { m_array[r].high  = haHigh; m_array[r].low = haLow;  } 
                              m_array[r].open  = haOpen;
                              m_array[r].close = haClose;
         //
         //
         //
         
         switch (tprice)
         {
            case pr_haclose:
            case pr_habclose:    return(haClose);
            case pr_haopen:   
            case pr_habopen:     return(haOpen);
            case pr_hahigh: 
            case pr_habhigh:     return(haHigh);
            case pr_halow:    
            case pr_hablow:      return(haLow);
            case pr_hamedian:
            case pr_habmedian:   return((haHigh+haLow)/2.0);
            case pr_hamedianb:
            case pr_habmedianb:  return((haOpen+haClose)/2.0);
            case pr_hatypical:
            case pr_habtypical:  return((haHigh+haLow+haClose)/3.0);
            case pr_haweighted:
            case pr_habweighted: return((haHigh+haLow+haClose+haClose)/4.0);
            case pr_haaverage:  
            case pr_habaverage:  return((haHigh+haLow+haClose+haOpen)/4.0);
            case pr_hatbiased:
            case pr_habtbiased:
               if (haClose>haOpen)
                     return((haHigh+haClose)/2.0);
               else  return((haLow+haClose)/2.0);        
            case pr_hatbiased2:
            case pr_habtbiased2:
               if (haClose>haOpen)  return(haHigh);
               if (haClose<haOpen)  return(haLow);
                                    return(haClose);        
         }
   }
   
   //
   //
   //

   switch (tprice)
   {
      case pr_close:     return(close[i]);
      case pr_open:      return(open[i]);
      case pr_high:      return(high[i]);
      case pr_low:       return(low[i]);
      case pr_median:    return((high[i]+low[i])/2.0);
      case pr_medianb:   return((open[i]+close[i])/2.0);
      case pr_typical:   return((high[i]+low[i]+close[i])/3.0);
      case pr_weighted:  return((high[i]+low[i]+close[i]+close[i])/4.0);
      case pr_average:   return((high[i]+low[i]+close[i]+open[i])/4.0);
      case pr_tbiased:   
               if (close[i]>open[i])
                     return((high[i]+close[i])/2.0);
               else  return((low[i]+close[i])/2.0);        
      case pr_tbiased2:   
               if (close[i]>open[i]) return(high[i]);
               if (close[i]<open[i]) return(low[i]);
                                     return(close[i]);        
   }
return(0);
}
